<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>flix-play.com/apks</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .backdrop-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -1;
        }
        .backdrop {
            width: 100%;
            height: 100%;
            object-fit: cover;
            position: absolute;
            opacity: 0;
            transform: scale(1);
            transition: opacity 3s ease-in-out, transform 3s ease-in-out;
        }

        .backdrop.visible {
            opacity: 1;
            transform: scale(1.1);
        }

        .backdrop.previous {
            opacity: 0;
            transform: scale(1);
        }

        .left-fade {
            position: absolute;
            top: 0;
            left: 0;
            width: 300px;
            height: 100%;
            background: linear-gradient(to right, #aba4a4, rgba(34, 34, 34, 0));
            z-index: 1;
        }
    </style>
</head>
<body>
    <div class="backdrop-container">
        <img id="backdrop1" class="backdrop">
        <img id="backdrop2" class="backdrop">
    </div>
    <div class="left-fade"></div>
    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2';
        let currentIndex = 0;
        let movieIds = [];
        let isBackdrop1Visible = true;

        async function fetchPopularMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=pt`);
                if (!response.ok) {
                    throw new Error('Failed to fetch popular movies');
                }
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Error fetching popular movies:', error);
            }
        }

        async function fetchMovieBackdrop(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie backdrop');
                }
                const data = await response.json();
                const backdropPath = data.backdrops[0]?.file_path; 
                return backdropPath ? `https://image.tmdb.org/t/p/original${backdropPath}` : null;
            } catch (error) {
                console.error('Error fetching movie backdrop:', error);
                return null;
            }
        }

        async function updateBackdrop() {
            if (movieIds.length === 0) {
                console.error('No movie IDs available.');
                return;
            }

            const movieId = movieIds[currentIndex];
            const backdrop1 = document.getElementById('backdrop1');
            const backdrop2 = document.getElementById('backdrop2');

            const currentBackdrop = isBackdrop1Visible ? backdrop1 : backdrop2;
            const nextBackdrop = isBackdrop1Visible ? backdrop2 : backdrop1;

            const backdropUrl = await fetchMovieBackdrop(movieId);
            if (backdropUrl) {
                nextBackdrop.src = backdropUrl;
            }

            currentBackdrop.classList.remove('visible');
            currentBackdrop.classList.add('previous');

            setTimeout(() => {
                nextBackdrop.classList.add('visible');
                nextBackdrop.classList.remove('previous');
            }, 3000);

            currentIndex = (currentIndex + 1) % movieIds.length;
            isBackdrop1Visible = !isBackdrop1Visible;
        }

        fetchPopularMovieIds().then(() => {
            setInterval(updateBackdrop, 9000);
            updateBackdrop();
        });
    </script>
</body>
</html>
