<?php
$dbPath = __DIR__ . '/api/.ansdb.db';
$db = new SQLite3($dbPath);

// Inicializar variáveis
$cliente = null;
$mensagem = "";
$mostrarFormulario = false;
$novoCadastro = false; // Variável para controlar se o formulário de cadastro deve ser exibido

// Quando o usuário buscar o MAC Address
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['buscar'])) {
    $mac_address = trim($_POST['mac_address']);

    if (!empty($mac_address)) {
        $stmt = $db->prepare("SELECT * FROM ibo WHERE mac_address = :mac");
        $stmt->bindValue(':mac', $mac_address, SQLITE3_TEXT);
        $result = $stmt->execute();
        $cliente = $result->fetchArray(SQLITE3_ASSOC);

        if ($cliente) {
            $mensagem = "Cadastro encontrado! Deseja alterar os dados?";
            $mostrarFormulario = true;
        } else {
            $mensagem = "Cliente não encontrado!";
            $novoCadastro = true; // Exibir formulário de novo cadastro
        }
    } else {
        $mensagem = "Por favor, insira um MAC Address.";
    }
}

// Quando o usuário salvar as alterações
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['salvar'])) {
    $mac_address = trim($_POST['mac_address']);
    $username = trim($_POST['username']);
    $expire_date = trim($_POST['expire_date']);
    $url = trim($_POST['url']);

    if (!empty($mac_address) && !empty($username) && !empty($expire_date) && !empty($url)) {
        $stmt = $db->prepare("UPDATE ibo SET username = :username, expire_date = :expire_date, url = :url WHERE mac_address = :mac");
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $stmt->bindValue(':expire_date', $expire_date, SQLITE3_TEXT);
        $stmt->bindValue(':url', $url, SQLITE3_TEXT);
        $stmt->bindValue(':mac', $mac_address, SQLITE3_TEXT);

        if ($stmt->execute()) {
            $mensagem = "Dados atualizados com sucesso!";
            $cliente = null; // Resetar formulário
            $mostrarFormulario = false;
        } else {
            $mensagem = "Erro ao atualizar os dados!";
        }
    } else {
        $mensagem = "Todos os campos são obrigatórios!";
    }
}

// Quando o usuário salvar o novo cadastro
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cadastrar'])) {
    $mac_address = trim($_POST['mac_address']);
    $username = trim($_POST['username']);
    $expire_date = trim($_POST['expire_date']);
    $url = trim($_POST['url']);

    if (!empty($mac_address) && !empty($username) && !empty($expire_date) && !empty($url)) {
        $stmt = $db->prepare("INSERT INTO ibo (mac_address, username, expire_date, url) VALUES (:mac, :username, :expire_date, :url)");
        $stmt->bindValue(':mac', $mac_address, SQLITE3_TEXT);
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $stmt->bindValue(':expire_date', $expire_date, SQLITE3_TEXT);
        $stmt->bindValue(':url', $url, SQLITE3_TEXT);

        if ($stmt->execute()) {
            $mensagem = "Novo cadastro realizado com sucesso!";
            $cliente = null; // Resetar formulário
            $mostrarFormulario = false;
        } else {
            $mensagem = "Erro ao cadastrar o cliente!";
        }
    } else {
        $mensagem = "Todos os campos são obrigatórios!";
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastrar Clientes</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #8d7054;
            margin: 0;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 350px;
        }
        h2 {
            margin-bottom: 20px;
        }
        input, button {
            width: 90%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            background: #28a745;
            color: black;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background: #218838;
        }
        .mensagem {
            margin-top: 10px;
            padding: 10px;
            background: #ffeb3b;
            border-radius: 5px;
        }
        .botoes {
            margin-top: 10px;
        }
        .btn-cancelar {
            background: #dc3545;
        }
        .btn-cancelar:hover {
            background: #c82333;
        }
        .logo {
            width: 150px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Logo adicionada -->
        <img src="img/logo.png" alt="Logo" class="logo">

        <h2>Digite o MAC abaixo</h2>
        <form method="post">
            <input type="text" name="mac_address" placeholder="Digite o MAC Address" value="<?php echo isset($cliente['mac_address']) ? htmlspecialchars($cliente['mac_address']) : ''; ?>" required>
            <button type="submit" name="buscar">Buscar</button>
        </form>

        <?php if (!empty($mensagem)): ?>
            <div class="mensagem"><?php echo $mensagem; ?></div>
            <?php if ($mostrarFormulario): ?>
                <div class="botoes">
                    <button onclick="document.getElementById('form-editar').style.display='block'">Sim</button>
                </div>
            <?php endif; ?>

            <?php if ($novoCadastro): ?>
                <div class="botoes">
                    <button onclick="document.getElementById('form-cadastro').style.display='block'">Cadastrar Novo Cliente?</button>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php if ($mostrarFormulario): ?>
            <div id="form-editar" style="display:none;">
                <h2>Editar Cliente</h2>
                <form method="post">
                    <input type="hidden" name="mac_address" value="<?php echo htmlspecialchars($cliente['mac_address']); ?>">

                    <input type="text" name="username" placeholder="Nome do Cliente" value="<?php echo htmlspecialchars($cliente['username']); ?>" required>

                    <input type="date" name="expire_date" value="<?php echo htmlspecialchars($cliente['expire_date']); ?>" required>

                    <input type="text" name="url" placeholder="URL da Lista IPTV" value="<?php echo htmlspecialchars($cliente['url']); ?>" required>

                    <button type="submit" name="salvar">Salvar Alterações</button>
                </form>
            </div>
        <?php endif; ?>

        <!-- Formulário de cadastro -->
        <?php if ($novoCadastro): ?>
            <div id="form-cadastro" style="display:none;">
                <h2>Cadastrar Novo Cliente</h2>
                <form method="post">
                    <input type="text" name="mac_address" placeholder="MAC Address" required>
                    <input type="text" name="username" placeholder="Nome do Cliente" required>
                    <input type="date" name="expire_date" required>
                    <input type="text" name="url" placeholder="URL da Lista IPTV" required>

                    <button type="submit" name="cadastrar">Cadastrar</button>
                </form>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
