<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Carrossel Infinito com Borda e Espaços</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            overflow: hidden;
            background-color: #000;
        }

        .banner-container {
            width: 100%;
            white-space: nowrap;
            overflow: hidden;
            display: flex;
            align-items: center;
            padding: 20px 0; /* Espaço externo de 20px no topo e embaixo */
            box-sizing: border-box;
        }

        .movie-poster {
            max-height: calc(100vh - 35px); /* Ajusta a altura das imagens com o espaço externo */
            flex-shrink: 0;
            border-radius: 5px;
            border: 2px solid #808080; /* Borda cinza */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.5);
            margin-right: 5px; /* Espaçamento entre as imagens */
            box-sizing: border-box; /* Inclui bordas e margens no cálculo de tamanho */
        }
    </style>
</head>
<body>
    <div class="banner-container" id="movie-banner">
        <!-- Capas renderizadas dinamicamente -->
    </div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2';
        let movieIds = [];
        let movieCache = [];
        const visibleImages = 15; // Número fixo de imagens visíveis no DOM
        const scrollSpeed = 0.7; // Velocidade de rolagem
        let isScrolling = true;

        async function fetchPopularMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&language=pt-BR&sort_by=popularity.desc`);
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Erro ao buscar IDs de filmes:', error);
            }
        }

        async function preloadMoviePosters() {
            for (let movieId of movieIds) {
                try {
                    const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=pt-BR`);
                    const data = await response.json();
                    const posterPath = `https://image.tmdb.org/t/p/original${data.poster_path}`;

                    const img = new Image();
                    img.src = posterPath;
                    img.alt = data.title;
                    img.className = 'movie-poster';

                    await new Promise((resolve, reject) => {
                        img.onload = resolve;
                        img.onerror = reject;
                    });

                    movieCache.push(img); // Adiciona ao cache
                } catch (error) {
                    console.error('Erro ao pré-carregar filme:', error);
                }
            }
        }

        function renderInitialImages() {
            const movieBanner = document.getElementById('movie-banner');
            for (let i = 0; i < visibleImages; i++) {
                if (movieCache[i]) {
                    movieBanner.appendChild(movieCache[i]);
                }
            }
        }

        function startInfiniteScroll() {
            const movieBanner = document.getElementById('movie-banner');

            function scroll() {
                if (isScrolling) {
                    movieBanner.scrollLeft += scrollSpeed;

                    // Detecta se a primeira imagem saiu completamente do viewport
                    const firstImage = movieBanner.firstElementChild;
                    if (firstImage.getBoundingClientRect().right <= 0) {
                        // Remove a imagem do início e a reposiciona no final
                        movieBanner.appendChild(firstImage);
                        movieBanner.scrollLeft -= firstImage.offsetWidth + 10; // Compensa o gap entre imagens
                    }
                }
                requestAnimationFrame(scroll);
            }

            scroll();
        }

        async function init() {
            await fetchPopularMovieIds();
            if (movieIds.length > 0) {
                await preloadMoviePosters(); // Pré-carrega todas as capas
                renderInitialImages(); // Renderiza as primeiras imagens
                startInfiniteScroll(); // Inicia o carrossel infinito
            } else {
                console.error('Nenhum ID de filme encontrado.');
            }
        }

        init();
    </script>
</body>
</html>
